/*
 * Decompiled with CFR 0.152.
 */
package com.bdlington.Catalyst.modules;

import com.bdlington.Catalyst.CatalystAddon;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.player.FindItemResult;
import meteordevelopment.meteorclient.utils.player.InvUtils;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1820;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2482;
import net.minecraft.class_2510;
import net.minecraft.class_2680;
import net.minecraft.class_3489;
import net.minecraft.class_3532;
import net.minecraft.class_3612;

public class UndetectedTunneler
extends Module {
    private final SettingGroup sgGeneral;
    private final SettingGroup sgSafety;
    private final SettingGroup sgRotation;
    private final Setting<Integer> scanDepth;
    private final Setting<Boolean> humanLikeRotation;
    private final Setting<Boolean> chatFeedback;
    private final Setting<Integer> yLevel;
    private final Setting<Integer> scanHeight;
    private final Setting<Integer> safetyMargin;
    private final Setting<Boolean> strictGroundCheck;
    private final Setting<Integer> scanFrequency;
    private final Setting<Integer> backtrackDistance;
    private final Setting<Boolean> smoothRotation;
    private final Setting<Double> rotationSpeed;
    private final Setting<Double> rotationAcceleration;
    private final Setting<Double> overshootChance;
    private MiningState currentState;
    private DirectionManager directionManager;
    private PathScanner pathScanner;
    private SafetyValidator safetyValidator;
    private BacktrackManager backtrackManager;
    private RotationController rotationController;
    private int blocksMined;
    private class_243 lastPos;
    private int scanTicks;
    private int ticksSinceActivation;
    private int lastCenterTick;
    private int stateTransitionDelay;
    private int rotationLockoutTicks;
    private boolean hasCentered;
    private boolean packetSentThisTick;
    private class_2338 miningBlock;
    private int centeringTicks;
    private class_243 centeringTarget;
    private class_2350 pendingDirection;
    private BacktrackManager.BacktrackPlan currentBacktrackPlan;

    public UndetectedTunneler() {
        super(CatalystAddon.CATEGORY, "UndetectedTunneler", "Automatically mines 1x1 tunnels below Y=-50.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.sgSafety = this.settings.createGroup("Safety");
        this.sgRotation = this.settings.createGroup("Rotation");
        this.scanDepth = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("scan-depth")).description("How many blocks ahead to scan for hazards.")).defaultValue((Object)6)).range(4, 10).sliderRange(4, 10).build());
        this.humanLikeRotation = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("human-like-rotation")).description("Add human-like imperfections to rotation.")).defaultValue((Object)true)).build());
        this.chatFeedback = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("chat-feedback")).description("Show info and warning messages in chat.")).defaultValue((Object)true)).build());
        this.yLevel = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("y-level")).description("Maximum Y level to operate at.")).defaultValue((Object)-50)).range(-64, -10).sliderRange(-64, -10).visible(() -> false)).build());
        this.scanHeight = this.sgSafety.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("scan-height")).description("How many blocks above to scan for falling blocks.")).defaultValue((Object)3)).range(3, 8).sliderRange(3, 8).visible(() -> false)).build());
        this.safetyMargin = this.sgSafety.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("safety-margin")).description("Blocks before hazard to stop mining.")).defaultValue((Object)4)).range(1, 4).sliderRange(1, 4).visible(() -> false)).build());
        this.strictGroundCheck = this.sgSafety.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("strict-ground-check")).description("Require solid ground for scan area.")).defaultValue((Object)false)).visible(() -> false)).build());
        this.scanFrequency = this.sgSafety.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("scan-frequency")).description("How often to scan for hazards while mining (in ticks).")).defaultValue((Object)1)).range(1, 20).sliderRange(1, 20).visible(() -> false)).build());
        this.backtrackDistance = this.sgSafety.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("backtrack-distance")).description("How many blocks to go back when both sides are blocked.")).defaultValue((Object)20)).range(10, 50).sliderRange(10, 50).visible(() -> false)).build());
        this.smoothRotation = this.sgRotation.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("smooth-rotation")).description("Use smooth rotation instead of instant snapping.")).defaultValue((Object)true)).visible(() -> false)).build());
        this.rotationSpeed = this.sgRotation.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("rotation-speed")).description("Base rotation speed.")).defaultValue(3.0).range(1.0, 5.0).sliderRange(1.0, 5.0).visible(() -> false)).build());
        this.rotationAcceleration = this.sgRotation.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("rotation-acceleration")).description("How quickly rotation speeds up and slows down.")).defaultValue(0.5).range(0.1, 1.0).sliderRange(0.1, 1.0).visible(() -> false)).build());
        this.overshootChance = this.sgRotation.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("overshoot-chance")).description("Chance to overshoot target rotation.")).defaultValue(0.2).range(0.0, 1.0).sliderRange(0.0, 1.0).visible(() -> false)).build());
        this.currentState = MiningState.IDLE;
        this.blocksMined = 0;
        this.lastPos = class_243.field_1353;
        this.scanTicks = 0;
        this.ticksSinceActivation = 0;
        this.lastCenterTick = -30;
        this.stateTransitionDelay = 0;
        this.rotationLockoutTicks = 30;
        this.hasCentered = false;
        this.packetSentThisTick = false;
        this.miningBlock = null;
        this.centeringTicks = 0;
        this.centeringTarget = null;
    }

    public void onActivate() {
        this.warning("Works for 1x1, 2x1 tunnels. Very beta version, might get stuck sometimes", new Object[0]);
        if (this.mc.field_1724 == null || this.mc.field_1687 == null || !this.mc.field_1724.method_5805() || this.mc.field_1724.field_3944 == null || !this.mc.field_1724.field_3944.method_48296().method_10758()) {
            this.senderror("Invalid player or server state! Cannot activate module.");
            this.toggle();
            return;
        }
        if (this.mc.field_1724.method_23318() > (double)((Integer)this.yLevel.get()).intValue()) {
            this.senderror("You must be below Y=" + String.valueOf(this.yLevel.get()) + " to use this module! Current Y: " + Math.round(this.mc.field_1724.method_23318()));
            this.toggle();
            return;
        }
        try {
            this.directionManager = new DirectionManager(this);
            this.pathScanner = new PathScanner();
            this.safetyValidator = new SafetyValidator();
            this.backtrackManager = new BacktrackManager(this);
            this.rotationController = new RotationController();
        }
        catch (Exception e) {
            this.senderror("Failed to initialize components: " + e.getMessage());
            this.toggle();
            return;
        }
        this.resetMovement();
        this.currentState = MiningState.IDLE;
        this.blocksMined = 0;
        this.lastPos = this.mc.field_1724.method_19538();
        this.scanTicks = 0;
        this.ticksSinceActivation = 0;
        this.lastCenterTick = -30;
        this.stateTransitionDelay = 0;
        this.rotationLockoutTicks = 30;
        this.hasCentered = false;
        this.centeringTicks = 0;
        this.centeringTarget = null;
        this.packetSentThisTick = false;
        this.miningBlock = null;
        this.sendInfo("AITunneler activated at Y=" + Math.round(this.mc.field_1724.method_23318()) + ". Waiting for initialization...");
    }

    public void onDeactivate() {
        this.resetMovement();
        this.currentState = MiningState.IDLE;
        if (this.safetyValidator != null) {
            this.safetyValidator.reset();
        }
        this.miningBlock = null;
        this.sendInfo("AITunneler deactivated.");
    }

    private void resetMovement() {
        if (this.mc.field_1690 != null) {
            this.mc.field_1690.field_1886.method_23481(false);
            this.mc.field_1690.field_1894.method_23481(false);
            this.mc.field_1690.field_1881.method_23481(false);
            this.mc.field_1690.field_1913.method_23481(false);
            this.mc.field_1690.field_1849.method_23481(false);
        }
        if (this.mc.field_1724 != null) {
            this.mc.field_1724.method_18800(0.0, this.mc.field_1724.method_18798().field_1351, 0.0);
        }
        if (this.mc.field_1761 != null && this.miningBlock != null) {
            this.mc.field_1761.method_2925();
            this.miningBlock = null;
        }
    }

    private void sendInfo(String message) {
        if (((Boolean)this.chatFeedback.get()).booleanValue()) {
            this.info(message, new Object[0]);
        }
    }

    private void sendWarning(String message) {
        if (((Boolean)this.chatFeedback.get()).booleanValue()) {
            this.warning(message, new Object[0]);
        }
    }

    private void senderror(String message) {
        if (((Boolean)this.chatFeedback.get()).booleanValue()) {
            this.error(message, new Object[0]);
        }
    }

    @EventHandler
    private void onTick(TickEvent.Post event) {
        if (this.mc.field_1724 == null || this.mc.field_1687 == null || !this.mc.field_1724.method_5805() || this.mc.field_1724.field_3944 == null || !this.mc.field_1724.field_3944.method_48296().method_10758()) {
            this.toggle();
            return;
        }
        if (this.mc.field_1755 != null) {
            this.resetMovement();
            return;
        }
        ++this.ticksSinceActivation;
        if (this.rotationLockoutTicks > 0) {
            --this.rotationLockoutTicks;
        }
        this.packetSentThisTick = false;
        if (this.mc.field_1724.method_23318() > (double)((Integer)this.yLevel.get()).intValue()) {
            this.senderror("Moved above Y=" + String.valueOf(this.yLevel.get()) + "! Disabling module for safety.");
            this.toggle();
            return;
        }
        if (this.currentState == MiningState.IDLE && this.ticksSinceActivation >= 30) {
            this.currentState = MiningState.CENTERING;
            this.resetMovement();
            this.sendInfo("Starting centering phase.");
        }
        if (this.stateTransitionDelay > 0) {
            --this.stateTransitionDelay;
            return;
        }
        this.pathScanner.updateScanWidths(0, 0);
        this.rotationController.updateSettings((Boolean)this.smoothRotation.get(), (Double)this.rotationSpeed.get(), (Double)this.rotationAcceleration.get(), (Boolean)this.humanLikeRotation.get(), (Double)this.overshootChance.get());
        if (!this.safetyValidator.canContinue((class_1657)this.mc.field_1724, (Integer)this.yLevel.get())) {
            this.senderror("Safety check failed!");
            this.toggle();
            return;
        }
        if (this.safetyValidator.checkStuck((class_1657)this.mc.field_1724)) {
            this.senderror("Player stuck, initiating backtrack");
            this.resetMovement();
            this.currentState = MiningState.HAZARD_DETECTED;
            this.stateTransitionDelay = 3;
            return;
        }
        FindItemResult pickaxe = InvUtils.findInHotbar(this::isTool);
        if (!pickaxe.found()) {
            this.senderror("No pickaxe!");
            this.toggle();
            return;
        }
        if (!pickaxe.isMainHand()) {
            if (!this.packetSentThisTick) {
                InvUtils.swap((int)pickaxe.slot(), (boolean)false);
                this.packetSentThisTick = true;
                this.stateTransitionDelay = 3;
                this.sendInfo("Swapped to pickaxe, delaying next action.");
            }
            return;
        }
        if (this.currentState == MiningState.CENTERING && this.centeringTicks > 0) {
            this.gradualCenterPlayer();
            return;
        }
        if (this.rotationController.isRotating() && this.rotationLockoutTicks == 0 && !this.packetSentThisTick) {
            this.rotationController.update();
            this.packetSentThisTick = true;
            return;
        }
        try {
            switch (this.currentState.ordinal()) {
                case 1: {
                    this.handleCentering();
                    this.stateTransitionDelay = 3;
                    break;
                }
                case 2: {
                    this.handleScanning();
                    this.stateTransitionDelay = 3;
                    break;
                }
                case 3: {
                    this.handleMining();
                    this.stateTransitionDelay = 3;
                    break;
                }
                case 4: {
                    this.handleHazardDetected();
                    this.stateTransitionDelay = 3;
                    break;
                }
                case 6: {
                    this.handleRetracing();
                    this.stateTransitionDelay = 3;
                    break;
                }
                case 7: {
                    this.handleBacktracking();
                    this.stateTransitionDelay = 3;
                    break;
                }
                case 5: {
                    this.currentState = MiningState.CENTERING;
                    this.stateTransitionDelay = 3;
                    break;
                }
                case 8: {
                    this.toggle();
                }
            }
        }
        catch (Exception e) {
            this.senderror("Error in state machine: " + e.getMessage());
            this.toggle();
        }
    }

    private boolean isTool(class_1799 itemStack) {
        return itemStack.method_31573(class_3489.field_42614) || itemStack.method_31573(class_3489.field_42615) || itemStack.method_31573(class_3489.field_42612) || itemStack.method_7909() instanceof class_1820;
    }

    private boolean isPickaxe(class_1799 itemStack) {
        return itemStack.method_31573(class_3489.field_42614);
    }

    private void gradualCenterPlayer() {
        double targetZ;
        double dz;
        if (this.mc.field_1724 == null || this.packetSentThisTick) {
            return;
        }
        class_243 pos = this.mc.field_1724.method_19538();
        double targetX = Math.floor(pos.field_1352) + 0.5;
        double dx = targetX - pos.field_1352;
        double distance = Math.sqrt(dx * dx + (dz = (targetZ = Math.floor(pos.field_1350) + 0.5) - pos.field_1350) * dz);
        if (distance < 0.05 || this.centeringTicks <= 0) {
            this.centeringTicks = 0;
            this.centeringTarget = null;
            this.resetMovement();
            this.packetSentThisTick = true;
            this.sendInfo("Gradual centering complete.");
            return;
        }
        if (Math.abs(dx) > 0.05) {
            if (dx > 0.0) {
                this.mc.field_1690.field_1849.method_23481(true);
                this.mc.field_1690.field_1913.method_23481(false);
            } else {
                this.mc.field_1690.field_1913.method_23481(true);
                this.mc.field_1690.field_1849.method_23481(false);
            }
        } else {
            this.mc.field_1690.field_1913.method_23481(false);
            this.mc.field_1690.field_1849.method_23481(false);
        }
        if (Math.abs(dz) > 0.05) {
            if (dz > 0.0) {
                this.mc.field_1690.field_1894.method_23481(true);
                this.mc.field_1690.field_1881.method_23481(false);
            } else {
                this.mc.field_1690.field_1881.method_23481(true);
                this.mc.field_1690.field_1894.method_23481(false);
            }
        } else {
            this.mc.field_1690.field_1894.method_23481(false);
            this.mc.field_1690.field_1881.method_23481(false);
        }
        --this.centeringTicks;
        this.packetSentThisTick = true;
        this.sendInfo("Centering: Moving to (" + targetX + ", " + targetZ + "), ticks left: " + this.centeringTicks);
    }

    private void handleCentering() {
        if (!this.hasCentered && this.ticksSinceActivation - this.lastCenterTick >= 30 && this.isPlayerOffCenter()) {
            class_243 pos = this.mc.field_1724.method_19538();
            this.centeringTarget = new class_243(Math.floor(pos.field_1352) + 0.5, pos.field_1351, Math.floor(pos.field_1350) + 0.5);
            this.centeringTicks = 10;
            this.hasCentered = true;
            this.lastCenterTick = this.ticksSinceActivation;
            this.sendInfo("Starting gradual centering to " + String.valueOf(this.centeringTarget));
            this.gradualCenterPlayer();
            return;
        }
        float yaw = this.mc.field_1724.method_36454();
        class_2350 initialDir = this.getCardinalDirection(yaw);
        this.directionManager.setInitialDirection(initialDir);
        float targetYaw = this.directionToYaw(initialDir);
        this.currentState = MiningState.ROTATING;
        this.rotationController.startRotation(targetYaw, () -> {
            this.backtrackManager.startNewSegment(initialDir, this.mc.field_1724.method_19538());
            this.currentState = MiningState.SCANNING;
            this.sendInfo("Rotation complete, starting scan.");
        });
    }

    private boolean isPlayerOffCenter() {
        if (this.mc.field_1724 == null) {
            return false;
        }
        class_243 pos = this.mc.field_1724.method_19538();
        double xFrac = pos.field_1352 - Math.floor(pos.field_1352);
        double zFrac = pos.field_1350 - Math.floor(pos.field_1350);
        return Math.abs(xFrac - 0.5) > 0.1 || Math.abs(zFrac - 0.5) > 0.1;
    }

    private void handleScanning() {
        class_2350 currentDir;
        class_2338 playerPos = this.mc.field_1724.method_24515();
        PathScanner.ScanResult result = this.pathScanner.scanDirection(playerPos, currentDir = this.directionManager.getCurrentDirection(), (Integer)this.scanDepth.get(), (Integer)this.scanHeight.get(), (Boolean)this.strictGroundCheck.get());
        if (result.isSafe()) {
            this.currentState = MiningState.MINING;
            this.blocksMined = 0;
            this.scanTicks = 0;
            this.lastPos = this.mc.field_1724.method_19538();
            this.startMining(currentDir);
            this.sendInfo("Scan complete, starting mining in direction " + String.valueOf(currentDir));
        } else {
            String hazardName = this.getHazardName(result.getHazardType());
            this.sendWarning(hazardName + " detected, changing direction");
            this.currentState = MiningState.HAZARD_DETECTED;
            this.resetMovement();
            this.sendInfo("Movement stopped due to hazard.");
        }
    }

    private void startMining(class_2350 direction) {
        this.mc.field_1690.field_1886.method_23481(true);
        this.mc.field_1690.field_1894.method_23481(true);
        this.mc.field_1690.field_1881.method_23481(false);
        this.mc.field_1690.field_1913.method_23481(false);
        this.mc.field_1690.field_1849.method_23481(false);
        this.miningBlock = this.mc.field_1724.method_24515().method_10093(direction);
    }

    private void handleMining() {
        double distanceMoved;
        if (this.mc.field_1724.method_23318() > (double)((Integer)this.yLevel.get()).intValue()) {
            this.senderror("Moved above Y=" + String.valueOf(this.yLevel.get()) + " while mining! Stopping.");
            this.resetMovement();
            this.toggle();
            return;
        }
        class_243 currentPos = this.mc.field_1724.method_19538();
        ++this.scanTicks;
        if (this.scanTicks >= (Integer)this.scanFrequency.get()) {
            class_2350 currentDir;
            this.scanTicks = 0;
            class_2338 playerPos = this.mc.field_1724.method_24515();
            PathScanner.ScanResult result = this.pathScanner.scanDirection(playerPos, currentDir = this.directionManager.getCurrentDirection(), (Integer)this.scanDepth.get(), (Integer)this.scanHeight.get(), (Boolean)this.strictGroundCheck.get());
            if (!result.isSafe() && result.getHazardDistance() <= (Integer)this.safetyMargin.get()) {
                String hazardName = this.getHazardName(result.getHazardType());
                this.sendWarning(hazardName + " detected, changing direction");
                this.resetMovement();
                this.currentState = MiningState.HAZARD_DETECTED;
                this.sendInfo("Movement stopped due to hazard in mining.");
                return;
            }
        }
        if ((distanceMoved = currentPos.method_1022(this.lastPos)) >= 0.8) {
            ++this.blocksMined;
            this.lastPos = currentPos;
            this.directionManager.recordMovement(1);
            this.backtrackManager.recordMovement();
        }
        if (this.blocksMined >= 1) {
            this.resetMovement();
            class_2338 playerPos = this.mc.field_1724.method_24515();
            class_2350 currentDir = this.directionManager.getCurrentDirection();
            PathScanner.ScanResult result = this.pathScanner.scanDirection(playerPos, currentDir, (Integer)this.scanDepth.get(), (Integer)this.scanHeight.get(), (Boolean)this.strictGroundCheck.get());
            if (!result.isSafe() && result.getHazardDistance() <= (Integer)this.safetyMargin.get()) {
                String hazardName = this.getHazardName(result.getHazardType());
                this.sendWarning(hazardName + " detected, changing direction");
                this.currentState = MiningState.HAZARD_DETECTED;
                this.sendInfo("Movement stopped due to hazard in mining check.");
                return;
            }
            this.blocksMined = 0;
            this.scanTicks = 0;
            this.startMining(currentDir);
            this.sendInfo("Continuing mining in direction " + String.valueOf(currentDir));
        }
    }

    private void handleHazardDetected() {
        this.resetMovement();
        if (this.ticksSinceActivation - this.lastCenterTick >= 30 && this.isPlayerOffCenter()) {
            this.centeringTarget = new class_243(Math.floor(this.mc.field_1724.method_23317()) + 0.5, this.mc.field_1724.method_23318(), Math.floor(this.mc.field_1724.method_23321()) + 0.5);
            this.centeringTicks = 10;
            this.lastCenterTick = this.ticksSinceActivation;
            this.sendInfo("Starting gradual centering for hazard handling.");
            this.gradualCenterPlayer();
            return;
        }
        class_2350 currentDir = this.directionManager.getCurrentDirection();
        this.directionManager.recordHazard(currentDir, 0);
        DirectionManager.DirectionChoice choice = this.directionManager.getNextDirection();
        if (choice.needsBacktrack) {
            class_2350 mainTunnel = this.directionManager.getMainTunnel();
            this.currentBacktrackPlan = this.backtrackManager.createBacktrackPlan(mainTunnel, (Integer)this.backtrackDistance.get());
            this.sendInfo("Backtracking and trying again");
            if (this.currentBacktrackPlan.needsRetrace) {
                float targetYaw = this.directionToYaw(this.currentBacktrackPlan.retraceDirection);
                this.currentState = MiningState.ROTATING;
                this.rotationController.startRotation(targetYaw, () -> {
                    this.currentState = MiningState.RETRACING;
                    this.backtrackManager.startRetrace(this.currentBacktrackPlan.retraceDistance);
                    this.lastPos = this.mc.field_1724.method_19538();
                    this.mc.field_1690.field_1894.method_23481(true);
                    this.mc.field_1690.field_1881.method_23481(false);
                    this.mc.field_1690.field_1913.method_23481(false);
                    this.mc.field_1690.field_1849.method_23481(false);
                    this.sendInfo("Starting retrace in direction " + String.valueOf(this.currentBacktrackPlan.retraceDirection));
                });
            } else {
                this.startBacktrack();
            }
            return;
        }
        if (choice.direction == null) {
            this.senderror("No safe directions found!");
            this.currentState = MiningState.STOPPED;
            return;
        }
        this.pendingDirection = choice.direction;
        float targetYaw = this.directionToYaw(choice.direction);
        this.currentState = MiningState.ROTATING;
        this.rotationController.startRotation(targetYaw, () -> {
            this.backtrackManager.startNewSegment(this.pendingDirection, this.mc.field_1724.method_19538());
            this.currentState = MiningState.CENTERING;
            this.hasCentered = false;
            this.sendInfo("Rotation complete, centering before scanning in direction " + String.valueOf(this.pendingDirection));
        });
    }

    private void startBacktrack() {
        float targetYaw = this.directionToYaw(this.currentBacktrackPlan.backtrackDirection);
        this.currentState = MiningState.ROTATING;
        this.rotationController.startRotation(targetYaw, () -> {
            this.currentState = MiningState.BACKTRACKING;
            this.backtrackManager.startBacktrack(this.currentBacktrackPlan.backtrackDistance);
            this.lastPos = this.mc.field_1724.method_19538();
            this.mc.field_1690.field_1894.method_23481(true);
            this.mc.field_1690.field_1881.method_23481(false);
            this.mc.field_1690.field_1913.method_23481(false);
            this.mc.field_1690.field_1849.method_23481(false);
            this.sendInfo("Starting backtrack in direction " + String.valueOf(this.currentBacktrackPlan.backtrackDirection));
        });
    }

    private void handleRetracing() {
        class_243 currentPos = this.mc.field_1724.method_19538();
        double distanceMoved = currentPos.method_1022(this.lastPos);
        if (distanceMoved >= 0.8) {
            this.lastPos = currentPos;
            if (this.backtrackManager.updateRetrace()) {
                this.resetMovement();
                this.sendInfo("Retrace complete, starting backtrack.");
                this.startBacktrack();
            }
        }
    }

    private void handleBacktracking() {
        class_243 currentPos = this.mc.field_1724.method_19538();
        double distanceMoved = currentPos.method_1022(this.lastPos);
        if (distanceMoved >= 0.8) {
            this.lastPos = currentPos;
            if (this.backtrackManager.updateBacktrack()) {
                this.resetMovement();
                this.sendInfo("Backtrack complete.");
                this.backtrackManager.reset();
                this.directionManager.markBacktrackComplete();
                DirectionManager.DirectionChoice choice = this.directionManager.getNextDirection();
                if (choice.direction == null) {
                    this.senderror("No safe directions found after backtracking!");
                    this.currentState = MiningState.STOPPED;
                    return;
                }
                this.pendingDirection = choice.direction;
                float targetYaw = this.directionToYaw(choice.direction);
                this.currentState = MiningState.ROTATING;
                this.rotationController.startRotation(targetYaw, () -> {
                    this.backtrackManager.startNewSegment(this.pendingDirection, this.mc.field_1724.method_19538());
                    this.currentState = MiningState.CENTERING;
                    this.hasCentered = false;
                    this.sendInfo("Rotation complete, centering before scanning in direction " + String.valueOf(this.pendingDirection));
                });
            }
        }
    }

    private String getHazardName(PathScanner.HazardType type) {
        return switch (type.ordinal()) {
            case 1 -> "Lava";
            case 2 -> "Water";
            case 3 -> "Gravel";
            case 4 -> "Unsafe ground";
            case 5 -> "Dangerous block";
            default -> "Hazard";
        };
    }

    private class_2350 getCardinalDirection(float yaw) {
        if ((yaw = (yaw % 360.0f + 360.0f) % 360.0f) >= 315.0f || yaw < 45.0f) {
            return class_2350.field_11035;
        }
        if (yaw >= 45.0f && yaw < 135.0f) {
            return class_2350.field_11039;
        }
        if (yaw >= 135.0f && yaw < 225.0f) {
            return class_2350.field_11043;
        }
        return class_2350.field_11034;
    }

    private float directionToYaw(class_2350 dir) {
        return switch (dir) {
            case class_2350.field_11043 -> 180.0f;
            case class_2350.field_11035 -> 0.0f;
            case class_2350.field_11034 -> -90.0f;
            case class_2350.field_11039 -> 90.0f;
            default -> 0.0f;
        };
    }

    public static enum MiningState {
        IDLE,
        CENTERING,
        SCANNING,
        MINING,
        HAZARD_DETECTED,
        ROTATING,
        RETRACING,
        BACKTRACKING,
        STOPPED;

    }

    private class DirectionManager {
        private class_2350 currentDirection;
        private class_2350 lastMovementDirection;
        public final Map<class_2350, Integer> totalBlocksMined = new HashMap<class_2350, Integer>();
        private final Map<class_2350, Boolean> activeHazards = new HashMap<class_2350, Boolean>();
        private final Map<class_2350, Integer> consecutiveHazards = new HashMap<class_2350, Integer>();
        private int blocksSinceLastTurn = 0;
        private boolean justBacktracked = false;
        private final Random random = new Random();

        public DirectionManager(UndetectedTunneler undetectedTunneler) {
            for (class_2350 dir : this.getCardinalDirections()) {
                this.totalBlocksMined.put(dir, 0);
                this.activeHazards.put(dir, false);
                this.consecutiveHazards.put(dir, 0);
            }
        }

        public void setInitialDirection(class_2350 dir) {
            this.currentDirection = dir;
            this.lastMovementDirection = dir;
            this.blocksSinceLastTurn = 0;
            this.justBacktracked = false;
        }

        public class_2350 getCurrentDirection() {
            return this.currentDirection;
        }

        public class_2350 getMainTunnel() {
            class_2350 mainDir = this.currentDirection;
            int maxBlocks = 0;
            for (Map.Entry<class_2350, Integer> entry : this.totalBlocksMined.entrySet()) {
                if (entry.getValue() <= maxBlocks) continue;
                maxBlocks = entry.getValue();
                mainDir = entry.getKey();
            }
            return mainDir;
        }

        public DirectionChoice getNextDirection() {
            class_2350 opposite;
            if (this.justBacktracked) {
                this.justBacktracked = false;
                return this.getNextDirectionAfterBacktrack();
            }
            this.activeHazards.put(this.currentDirection, true);
            this.consecutiveHazards.put(this.currentDirection, this.consecutiveHazards.get(this.currentDirection) + 1);
            boolean immediateHazard = this.blocksSinceLastTurn < 3;
            class_2350 mainTunnel = this.getMainTunnel();
            if (this.currentDirection == mainTunnel) {
                boolean rightClear;
                class_2350 left = this.currentDirection.method_10160();
                class_2350 right = this.currentDirection.method_10170();
                boolean leftClear = this.activeHazards.get(left) == false || this.totalBlocksMined.get(left) == 0;
                boolean bl = rightClear = this.activeHazards.get(right) == false || this.totalBlocksMined.get(right) == 0;
                if (leftClear && rightClear) {
                    class_2350 chosen = this.totalBlocksMined.get(left) < this.totalBlocksMined.get(right) ? left : (this.totalBlocksMined.get(right) < this.totalBlocksMined.get(left) ? right : (this.random.nextBoolean() ? left : right));
                    this.lastMovementDirection = this.currentDirection;
                    this.currentDirection = chosen;
                    this.blocksSinceLastTurn = 0;
                    return new DirectionChoice(chosen, false, "Side tunnel from main");
                }
                if (leftClear) {
                    this.lastMovementDirection = this.currentDirection;
                    this.currentDirection = left;
                    this.blocksSinceLastTurn = 0;
                    return new DirectionChoice(left, false, "Left clear from main");
                }
                if (rightClear) {
                    this.lastMovementDirection = this.currentDirection;
                    this.currentDirection = right;
                    this.blocksSinceLastTurn = 0;
                    return new DirectionChoice(right, false, "Right clear from main");
                }
                return new DirectionChoice(null, true, "Backtrack in main tunnel");
            }
            if (immediateHazard) {
                opposite = this.lastMovementDirection.method_10153();
                class_2350 otherPerpendicular = null;
                for (class_2350 dir : this.getCardinalDirections()) {
                    if (dir == this.currentDirection || dir == this.lastMovementDirection || dir == opposite) continue;
                    otherPerpendicular = dir;
                    break;
                }
                if (otherPerpendicular != null && !this.activeHazards.get(otherPerpendicular).booleanValue()) {
                    this.currentDirection = otherPerpendicular;
                    this.blocksSinceLastTurn = 0;
                    return new DirectionChoice(otherPerpendicular, false, "Other perpendicular after immediate hazard");
                }
            }
            if (this.totalBlocksMined.get(this.currentDirection) > 10 && !immediateHazard) {
                this.blocksSinceLastTurn = 0;
                this.activeHazards.put(this.currentDirection, false);
                return new DirectionChoice(this.currentDirection, false, "Continue established side tunnel");
            }
            if (!this.activeHazards.get(mainTunnel).booleanValue() || this.consecutiveHazards.get(mainTunnel) < 2) {
                this.lastMovementDirection = this.currentDirection;
                this.currentDirection = mainTunnel;
                this.blocksSinceLastTurn = 0;
                this.activeHazards.put(mainTunnel, false);
                this.consecutiveHazards.put(mainTunnel, 0);
                return new DirectionChoice(mainTunnel, false, "Return to main tunnel");
            }
            opposite = mainTunnel.method_10153();
            if (!this.activeHazards.get(opposite).booleanValue()) {
                this.lastMovementDirection = this.currentDirection;
                this.currentDirection = opposite;
                this.blocksSinceLastTurn = 0;
                return new DirectionChoice(opposite, false, "Opposite of main tunnel");
            }
            return new DirectionChoice(null, true, "Backtrack in side tunnel");
        }

        public DirectionChoice getNextDirectionAfterBacktrack() {
            class_2350 chosen;
            this.activeHazards.put(this.currentDirection, false);
            this.consecutiveHazards.put(this.currentDirection, 0);
            class_2350 left = this.currentDirection.method_10160();
            class_2350 right = this.currentDirection.method_10170();
            this.activeHazards.put(left, false);
            this.activeHazards.put(right, false);
            if (this.totalBlocksMined.get(left) < this.totalBlocksMined.get(right)) {
                this.currentDirection = left;
                this.blocksSinceLastTurn = 0;
                return new DirectionChoice(left, false, "Left after backtrack");
            }
            if (this.totalBlocksMined.get(right) < this.totalBlocksMined.get(left)) {
                this.currentDirection = right;
                this.blocksSinceLastTurn = 0;
                return new DirectionChoice(right, false, "Right after backtrack");
            }
            this.currentDirection = chosen = this.random.nextBoolean() ? left : right;
            this.blocksSinceLastTurn = 0;
            return new DirectionChoice(chosen, false, "Random after backtrack");
        }

        public void recordMovement(int blocks) {
            this.totalBlocksMined.put(this.currentDirection, this.totalBlocksMined.get(this.currentDirection) + blocks);
            this.blocksSinceLastTurn += blocks;
        }

        public void recordHazard(class_2350 dir, int blocksMined) {
            this.activeHazards.put(dir, true);
        }

        public void markBacktrackComplete() {
            this.justBacktracked = true;
        }

        private class_2350[] getCardinalDirections() {
            return new class_2350[]{class_2350.field_11043, class_2350.field_11035, class_2350.field_11034, class_2350.field_11039};
        }

        public static class DirectionChoice {
            public final class_2350 direction;
            public final boolean needsBacktrack;
            public final String reason;

            public DirectionChoice(class_2350 direction, boolean needsBacktrack, String reason) {
                this.direction = direction;
                this.needsBacktrack = needsBacktrack;
                this.reason = reason;
            }
        }
    }

    private class PathScanner {
        private int scanWidthFallingBlocks = 0;
        private int scanWidthFluids = 0;

        private PathScanner() {
        }

        public void updateScanWidths(int fallingBlocks, int fluids) {
            this.scanWidthFallingBlocks = fallingBlocks;
            this.scanWidthFluids = fluids;
        }

        public ScanResult scanDirection(class_2338 start, class_2350 direction, int depth, int height, boolean strictGround) {
            int scanWidth = 0;
            for (int forward = 1; forward <= depth; ++forward) {
                for (int sideways = -scanWidth; sideways <= scanWidth; ++sideways) {
                    for (int vertical = -1; vertical <= height; ++vertical) {
                        class_2338 checkPos = this.offsetPosition(start, direction, forward, sideways, vertical);
                        class_2680 state = ((UndetectedTunneler)UndetectedTunneler.this).mc.field_1687.method_8320(checkPos);
                        HazardType fluidHazard = this.checkForFluids(state);
                        if (fluidHazard != HazardType.NONE) {
                            return new ScanResult(false, fluidHazard, forward);
                        }
                        HazardType hazard = this.checkBlock(checkPos, vertical, strictGround, forward, sideways, true);
                        if (hazard == HazardType.NONE) continue;
                        return new ScanResult(false, hazard, forward);
                    }
                }
            }
            return new ScanResult(true, HazardType.NONE, -1);
        }

        private HazardType checkForFluids(class_2680 state) {
            class_2248 block = state.method_26204();
            if (block == class_2246.field_10164 || state.method_26227().method_15772() == class_3612.field_15908 || state.method_26227().method_15772() == class_3612.field_15907) {
                return HazardType.LAVA;
            }
            if (block == class_2246.field_10382 || state.method_26227().method_15772() == class_3612.field_15910 || state.method_26227().method_15772() == class_3612.field_15909) {
                return HazardType.WATER;
            }
            return HazardType.NONE;
        }

        private HazardType checkBlock(class_2338 pos, int yOffset, boolean strictGround, int forwardDist, int sidewaysDist, boolean checkFalling) {
            class_2680 state = ((UndetectedTunneler)UndetectedTunneler.this).mc.field_1687.method_8320(pos);
            class_2248 block = state.method_26204();
            if (yOffset == -1 && sidewaysDist == 0 && !this.canWalkOn(pos, state)) {
                return HazardType.UNSAFE_GROUND;
            }
            if (checkFalling && yOffset >= 0 && this.isFallingBlock(block)) {
                return HazardType.FALLING_BLOCK;
            }
            if (this.isDangerousBlock(block)) {
                return HazardType.DANGEROUS_BLOCK;
            }
            return HazardType.NONE;
        }

        private boolean canWalkOn(class_2338 pos, class_2680 state) {
            if (state.method_26215()) {
                return false;
            }
            if (!state.method_26212((class_1922)((UndetectedTunneler)UndetectedTunneler.this).mc.field_1687, pos)) {
                return false;
            }
            class_2248 block = state.method_26204();
            if (block == class_2246.field_10092 || block == class_2246.field_17350 || block == class_2246.field_23860) {
                return false;
            }
            return state.method_26234((class_1922)((UndetectedTunneler)UndetectedTunneler.this).mc.field_1687, pos) || block instanceof class_2482 || block instanceof class_2510;
        }

        private boolean isFallingBlock(class_2248 block) {
            return block == class_2246.field_10102 || block == class_2246.field_10534 || block == class_2246.field_10255 || block == class_2246.field_10535 || block == class_2246.field_10105 || block == class_2246.field_10414 || block == class_2246.field_28048 || block == class_2246.field_28049;
        }

        private boolean isDangerousBlock(class_2248 block) {
            return block == class_2246.field_10375 || block == class_2246.field_10036 || block == class_2246.field_22089 || block == class_2246.field_10092 || block == class_2246.field_10606 || block == class_2246.field_16999 || block == class_2246.field_28048 || block == class_2246.field_27879 || block == class_2246.field_10029;
        }

        private class_2338 offsetPosition(class_2338 start, class_2350 forward, int forwardDist, int sidewaysDist, int verticalDist) {
            class_2350 left = forward.method_10160();
            return start.method_10079(forward, forwardDist).method_10079(left, sidewaysDist).method_10079(class_2350.field_11036, verticalDist);
        }

        public static enum HazardType {
            NONE,
            LAVA,
            WATER,
            FALLING_BLOCK,
            UNSAFE_GROUND,
            DANGEROUS_BLOCK;

        }

        public static class ScanResult {
            private final boolean safe;
            private final HazardType hazardType;
            private final int hazardDistance;

            public ScanResult(boolean safe, HazardType hazardType, int hazardDistance) {
                this.safe = safe;
                this.hazardType = hazardType;
                this.hazardDistance = hazardDistance;
            }

            public boolean isSafe() {
                return this.safe;
            }

            public HazardType getHazardType() {
                return this.hazardType;
            }

            public int getHazardDistance() {
                return this.hazardDistance;
            }
        }
    }

    private class SafetyValidator {
        private class_243 lastPosition;
        private int stuckTicks = 0;
        private static final int STUCK_THRESHOLD = 60;

        private SafetyValidator() {
        }

        public boolean canContinue(class_1657 player, int maxY) {
            int durability;
            if (player.method_23318() > (double)maxY) {
                return false;
            }
            if (!player.method_24828()) {
                return false;
            }
            if (player.method_6032() < 10.0f) {
                return false;
            }
            class_1799 mainHand = player.method_6047();
            return !UndetectedTunneler.this.isPickaxe(mainHand) || (durability = mainHand.method_7936() - mainHand.method_7919()) >= 100;
        }

        public boolean checkStuck(class_1657 player) {
            class_243 currentPos = new class_243(player.method_23317(), player.method_23318(), player.method_23321());
            if (this.lastPosition == null) {
                this.lastPosition = currentPos;
                return false;
            }
            double distance = currentPos.method_1022(this.lastPosition);
            if (distance < 0.1) {
                ++this.stuckTicks;
                if (this.stuckTicks >= 60) {
                    this.stuckTicks = 0;
                    return true;
                }
            } else {
                this.stuckTicks = 0;
                this.lastPosition = currentPos;
            }
            return false;
        }

        public void reset() {
            this.stuckTicks = 0;
            this.lastPosition = null;
        }

        public boolean isInValidMiningArea(class_1657 player) {
            return player.method_23318() <= -50.0 && player.method_24828();
        }

        public boolean hasValidTool(class_1657 player) {
            class_1799 mainHand = player.method_6047();
            return UndetectedTunneler.this.isPickaxe(mainHand);
        }
    }

    private class BacktrackManager {
        private final LinkedList<MoveSegment> moveHistory = new LinkedList();
        private MoveSegment currentSegment;
        private boolean isRetracing = false;
        private boolean isBacktracking = false;
        private int retraceBlocks = 0;
        private int backtrackBlocks = 0;

        private BacktrackManager(UndetectedTunneler undetectedTunneler) {
        }

        public void startNewSegment(class_2350 direction, class_243 startPos) {
            if (this.currentSegment != null && this.currentSegment.blocksMoved > 0) {
                this.moveHistory.addLast(this.currentSegment);
                if (this.moveHistory.size() > 5) {
                    this.moveHistory.removeFirst();
                }
            }
            this.currentSegment = new MoveSegment(direction, startPos);
        }

        public void recordMovement() {
            if (this.currentSegment != null) {
                ++this.currentSegment.blocksMoved;
            }
        }

        public BacktrackPlan createBacktrackPlan(class_2350 mainTunnelDirection, int backtrackDistance) {
            if (this.currentSegment != null && this.currentSegment.direction == mainTunnelDirection) {
                return new BacktrackPlan(false, true, null, 0, mainTunnelDirection.method_10153(), backtrackDistance, "Backtrack in main tunnel");
            }
            if (this.currentSegment != null && this.currentSegment.blocksMoved > 0) {
                return new BacktrackPlan(true, true, this.currentSegment.direction.method_10153(), this.currentSegment.blocksMoved, mainTunnelDirection.method_10153(), backtrackDistance, "Retrace side tunnel then backtrack in main");
            }
            return new BacktrackPlan(false, true, null, 0, mainTunnelDirection.method_10153(), backtrackDistance, "Direct backtrack");
        }

        public void startRetrace(int blocks) {
            this.isRetracing = true;
            this.retraceBlocks = blocks;
        }

        public void startBacktrack(int blocks) {
            this.isBacktracking = true;
            this.backtrackBlocks = blocks;
        }

        public boolean updateRetrace() {
            if (this.retraceBlocks > 0) {
                --this.retraceBlocks;
                return this.retraceBlocks == 0;
            }
            return true;
        }

        public boolean updateBacktrack() {
            if (this.backtrackBlocks > 0) {
                --this.backtrackBlocks;
                return this.backtrackBlocks == 0;
            }
            return true;
        }

        public void reset() {
            this.isRetracing = false;
            this.isBacktracking = false;
            this.retraceBlocks = 0;
            this.backtrackBlocks = 0;
        }

        public boolean isRetracing() {
            return this.isRetracing;
        }

        public boolean isBacktracking() {
            return this.isBacktracking;
        }

        public int getCurrentSegmentBlocks() {
            return this.currentSegment != null ? this.currentSegment.blocksMoved : 0;
        }

        public static class MoveSegment {
            public final class_2350 direction;
            public int blocksMoved;
            public final class_243 startPos;

            public MoveSegment(class_2350 direction, class_243 startPos) {
                this.direction = direction;
                this.startPos = startPos;
                this.blocksMoved = 0;
            }
        }

        public static class BacktrackPlan {
            public final boolean needsRetrace;
            public final boolean needsBacktrack;
            public final class_2350 retraceDirection;
            public final int retraceDistance;
            public final class_2350 backtrackDirection;
            public final int backtrackDistance;
            public final String description;

            public BacktrackPlan(boolean needsRetrace, boolean needsBacktrack, class_2350 retraceDirection, int retraceDistance, class_2350 backtrackDirection, int backtrackDistance, String description) {
                this.needsRetrace = needsRetrace;
                this.needsBacktrack = needsBacktrack;
                this.retraceDirection = retraceDirection;
                this.retraceDistance = retraceDistance;
                this.backtrackDirection = backtrackDirection;
                this.backtrackDistance = backtrackDistance;
                this.description = description;
            }
        }
    }

    private class RotationController {
        private final Random random = new Random();
        private float currentYaw;
        private float targetYaw;
        private float currentRotationSpeed;
        private boolean isRotating = false;
        private Runnable callback;
        private int rotationTickCounter = 0;
        private int overshootTicks = 0;
        private float overshootAmount = 0.0f;
        private boolean smoothRotation = true;
        private double baseSpeed = 3.0;
        private double acceleration = 0.5;
        private boolean humanLike = true;
        private double overshootChance = 0.2;

        private RotationController() {
        }

        public void updateSettings(boolean smooth, double speed, double accel, boolean human, double overshoot) {
            this.smoothRotation = smooth;
            this.baseSpeed = speed;
            this.acceleration = accel;
            this.humanLike = human;
            this.overshootChance = overshoot;
        }

        public void startRotation(float targetYaw, Runnable onComplete) {
            this.targetYaw = targetYaw;
            this.callback = onComplete;
            if (!this.smoothRotation) {
                if (!UndetectedTunneler.this.packetSentThisTick) {
                    this.setYawAngle(targetYaw);
                    UndetectedTunneler.this.packetSentThisTick = true;
                    UndetectedTunneler.this.sendInfo("Instant rotation to yaw " + targetYaw);
                    if (this.callback != null) {
                        this.callback.run();
                    }
                }
                return;
            }
            this.isRotating = true;
            this.currentYaw = ((UndetectedTunneler)UndetectedTunneler.this).mc.field_1724.method_36454();
            this.currentRotationSpeed = 0.0f;
            this.rotationTickCounter = 0;
            if (this.humanLike && this.random.nextDouble() < this.overshootChance) {
                float totalRotation = class_3532.method_15393((float)(targetYaw - this.currentYaw));
                this.overshootAmount = (2.0f + this.random.nextFloat() * 3.0f) * (float)(totalRotation > 0.0f ? 1 : -1);
                this.overshootTicks = 8 + this.random.nextInt(10);
            } else {
                this.overshootAmount = 0.0f;
                this.overshootTicks = 0;
            }
            UndetectedTunneler.this.sendInfo("Starting smooth rotation to yaw " + targetYaw);
        }

        public void update() {
            float targetSpeed;
            float deltaAngle;
            float distance;
            if (!this.isRotating || UndetectedTunneler.this.rotationLockoutTicks > 0 || UndetectedTunneler.this.packetSentThisTick) {
                return;
            }
            ++this.rotationTickCounter;
            if (this.rotationTickCounter % 2 != 0) {
                return;
            }
            float actualTarget = this.targetYaw;
            if (this.overshootTicks > 0) {
                actualTarget = this.targetYaw + this.overshootAmount;
                --this.overshootTicks;
            }
            if ((double)(distance = Math.abs(deltaAngle = class_3532.method_15393((float)(actualTarget - this.currentYaw)))) < 0.1) {
                this.setYawAngle(this.targetYaw);
                this.isRotating = false;
                UndetectedTunneler.this.packetSentThisTick = true;
                UndetectedTunneler.this.sendInfo("Rotation complete to yaw " + this.targetYaw);
                if (this.callback != null) {
                    this.callback.run();
                }
                return;
            }
            if (distance > 45.0f) {
                targetSpeed = (float)(this.baseSpeed * 1.2);
            } else if (distance > 15.0f) {
                targetSpeed = (float)this.baseSpeed;
            } else {
                targetSpeed = (float)(this.baseSpeed * (double)(distance / 15.0f));
                targetSpeed = Math.max(targetSpeed, 0.3f);
            }
            float accel = (float)this.acceleration;
            this.currentRotationSpeed = this.currentRotationSpeed < targetSpeed ? Math.min(this.currentRotationSpeed + accel, targetSpeed) : Math.max(this.currentRotationSpeed - accel, targetSpeed);
            float jitter = 0.0f;
            float speedVariation = 1.0f;
            if (this.humanLike) {
                jitter = (this.random.nextFloat() - 0.5f) * 0.1f;
                speedVariation = 0.95f + this.random.nextFloat() * 0.1f;
                if ((double)this.random.nextFloat() < 0.01 && distance > 10.0f) {
                    this.currentRotationSpeed *= 0.5f;
                }
            }
            float step = Math.min(Math.min(distance, this.currentRotationSpeed * speedVariation), 5.0f);
            if (deltaAngle < 0.0f) {
                step = -step;
            }
            this.currentYaw += step + jitter;
            this.setYawAngle(this.currentYaw);
            UndetectedTunneler.this.packetSentThisTick = true;
            UndetectedTunneler.this.sendInfo("Rotating: current yaw " + this.currentYaw + ", target " + this.targetYaw);
            if (distance < 0.5f || this.overshootTicks == 0 && (double)distance < 1.5) {
                this.setYawAngle(this.targetYaw);
                this.isRotating = false;
                UndetectedTunneler.this.packetSentThisTick = true;
                UndetectedTunneler.this.sendInfo("Rotation complete to yaw " + this.targetYaw);
                if (this.callback != null) {
                    this.callback.run();
                }
            }
        }

        private void setYawAngle(float yawAngle) {
            ((UndetectedTunneler)UndetectedTunneler.this).mc.field_1724.method_36456(yawAngle);
            ((UndetectedTunneler)UndetectedTunneler.this).mc.field_1724.field_6241 = yawAngle;
            ((UndetectedTunneler)UndetectedTunneler.this).mc.field_1724.field_6283 = yawAngle;
        }

        public boolean isRotating() {
            return this.isRotating;
        }
    }
}

